(async () => {
  const res = await fetch("cookie-banner.html");
  const html = await res.text();

  const temp = document.createElement("div");
  temp.innerHTML = html;

  // move <style> to <head>
  temp.querySelectorAll("style").forEach(s => document.head.appendChild(s));

  // move banner + modal to body
  temp.querySelectorAll("#kk-cookie-banner, #kk-modal").forEach(el => {
    document.body.appendChild(el);
  });

  // run inline scripts (important!)
  temp.querySelectorAll("script").forEach(old => {
    const s = document.createElement("script");
    if (old.src) s.src = old.src;
    else s.textContent = old.textContent;
    document.body.appendChild(s);
  });
})();